

######################################################
##### Plot All
######################################################

rm(list = ls())
dat = read.csv("Figure2.csv", header=TRUE)

png("Figure 2. Religious Bonding in Muslim- and Catholic-Majority Countries.png", width=4000, height=2000, res=300)

plot(dat$rdi2010[dat$muslim==1], dat$bonding1[dat$muslim==1], xlab="Religious Diversity Index", ylab="Close Friends with Similar Religion", cex.lab=1.6, cex.axis=1.6, 
     xlim=c(-.05, 6.5), ylim=c(3,5), col="dark green", yaxt='n')
points(dat$rdi2010[dat$muslim==0], dat$bonding1[dat$muslim==0], col="blue", pch=2)

axis(2,at=seq(3,5),labels=c("Some","Most","All"), cex.axis=1.6)

text(x=dat$rdi2010[dat$muslim==1], y=dat$bonding1[dat$muslim==1], labels=dat$countrycode[dat$muslim==1], col="dark green", cex=1.3, pos=4)
text(x=dat$rdi2010[dat$muslim==0], y=dat$bonding1[dat$muslim==0], labels=dat$countrycode[dat$muslim==0], col="blue", cex=1.3, pos=4)


meanMuslim = mean(dat$bonding1[dat$muslim==1], na.rm=TRUE)
meanCatholic = mean(dat$bonding1[dat$muslim==0], na.rm=TRUE)

text(5.5, meanMuslim+.01, labels="Mean of Muslim countries", cex=1.1, col="dark green")
text(5.5, meanCatholic, labels="Mean of Catholic countries", cex=1.1, col="blue")


abline(a=meanMuslim,b=0,lty=2,col="dark green")
abline(a=meanCatholic,b=0,lty=2,col="blue")

dev.off()

